/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.util;

import cn.com.yusys.udp.cloud.message.constant.PoolConfig;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.stream.binding.BindingTargetFactory;
import org.springframework.util.StringUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    public static BindingTargetFactory getBindingTargetFactory(Class<?> bindingTargetType, Map<String, BindingTargetFactory> bindingTargetFactories) {
        ArrayList<String> candidateBindingTargetFactories = new ArrayList<String>();
        for (Map.Entry<String, BindingTargetFactory> bindingTargetFactoryEntry : bindingTargetFactories.entrySet()) {
            if (!bindingTargetFactoryEntry.getValue().canCreate(bindingTargetType)) continue;
            candidateBindingTargetFactories.add(bindingTargetFactoryEntry.getKey());
        }
        if (candidateBindingTargetFactories.size() == 1) {
            return bindingTargetFactories.get(candidateBindingTargetFactories.get(0));
        }
        if (candidateBindingTargetFactories.isEmpty()) {
            throw new IllegalStateException("No factory found for binding target type: " + bindingTargetType.getName() + " among registered factories: " + StringUtils.collectionToCommaDelimitedString(bindingTargetFactories.keySet()));
        }
        throw new IllegalStateException("Multiple factories found for binding target type: " + bindingTargetType.getName() + ": " + StringUtils.collectionToCommaDelimitedString(candidateBindingTargetFactories));
    }

    public static ExecutorService getExecutorService(String poolName, PoolConfig poolConfig) {
        int coreSize = Runtime.getRuntime().availableProcessors() * 4;
        if (poolConfig.getPoolSize() < coreSize) {
            coreSize = poolConfig.getPoolSize();
        }
        return new ThreadPoolExecutor(coreSize, poolConfig.getPoolSize(), (long)poolConfig.getKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(poolConfig.getQueueSize()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build());
    }

    public static ScheduledExecutorService getScheduledExecutorService(String poolName, PoolConfig poolConfig) {
        int coreSize = Runtime.getRuntime().availableProcessors() * 4;
        if (poolConfig.getPoolSize() < coreSize) {
            coreSize = poolConfig.getPoolSize();
        }
        return new ScheduledThreadPoolExecutor(coreSize, new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build());
    }
}

