/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.rule.impl;

import cn.com.yusys.udp.cloud.message.exception.MessageException;
import cn.com.yusys.udp.cloud.message.rule.MessageEventStrategy;
import cn.com.yusys.yusp.commons.util.Predicates;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.AntPathMatcher;

public class DefaultMessageEventStrategy
implements MessageEventStrategy {
    private static final String CHANNEL_SPLIT_FLAG = "-";
    static final String MEMORY_SUFFIX = "-mem";
    private static final String PUBLISH_SUBSCRIBABLE_EXCHANGE = "udp-all";
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher(".");
    final Map<String, MessageEventStrategy.Channel> channelCache = new ConcurrentHashMap<String, MessageEventStrategy.Channel>();
    final BindingServiceProperties bindingServiceProperties;
    private final Logger log = LoggerFactory.getLogger(DefaultMessageEventStrategy.class);
    private final Map<String, MessageEventStrategy.Channel> producerEventChannelCache = new ConcurrentHashMap<String, MessageEventStrategy.Channel>();
    private final Map<String, MessageEventStrategy.Channel> consumerEventChannelCache = new ConcurrentHashMap<String, MessageEventStrategy.Channel>();
    private Predicate<String> memoryPredicate = Predicates.alwaysFalse();

    public DefaultMessageEventStrategy(List<String> memories, BindingServiceProperties bindingServiceProperties) {
        this.bindingServiceProperties = bindingServiceProperties;
        this.initMemoryPrefix(memories);
    }

    void initMemoryPrefix(List<String> memories) {
        if (CollectionUtils.nonEmpty(memories)) {
            this.memoryPredicate = memories.stream().map(this::ant).reduce((xva$0, xva$1) -> Predicates.or((Predicate[])new Predicate[]{xva$0, xva$1})).orElse(Predicates.alwaysFalse());
        }
    }

    Predicate<String> ant(String pattern) {
        return path -> ANT_PATH_MATCHER.match(pattern, path);
    }

    @Override
    public MessageEventStrategy.Channel resolveChannel(String event, boolean producer) {
        if (StringUtils.isEmpty((CharSequence)event)) {
            throw new MessageException("event cannot be null.");
        }
        return producer ? this.resolveOutputChannel(event) : this.resolveInputChannel(event);
    }

    protected synchronized MessageEventStrategy.Channel resolveInputChannel(String event) {
        MessageEventStrategy.Channel channel = this.consumerEventChannelCache.get(event);
        if (channel != null) {
            return channel;
        }
        channel = this.assemblyDestination(event, false);
        return Optional.ofNullable(this.consumerEventChannelCache.putIfAbsent(event, channel)).orElse(channel);
    }

    protected synchronized MessageEventStrategy.Channel resolveOutputChannel(String event) {
        MessageEventStrategy.Channel channel = this.producerEventChannelCache.get(event);
        if (channel != null) {
            return channel;
        }
        channel = this.assemblyDestination(event, true);
        return Optional.ofNullable(this.producerEventChannelCache.putIfAbsent(event, channel)).orElse(channel);
    }

    protected MessageEventStrategy.Channel assemblyDestination(String event, boolean producer) {
        String suffix = producer ? "-out" : "-in";
        MessageEventStrategy.Channel channel = new MessageEventStrategy.Channel();
        String destination = this.resolveDestination(event, channel);
        if (destination == null) {
            this.log.error("Not Match spec format,please use 'a.b.c'.");
            channel.setName(event);
            return Optional.ofNullable(this.channelCache.putIfAbsent(event, channel)).orElse(channel);
        }
        channel.setDestination(destination);
        this.log.debug("parse event:{} channel name.", (Object)event);
        String name = this.name(channel, producer);
        name = name + suffix;
        if (this.matchMemory(event)) {
            channel.setType("memory");
            name = name + MEMORY_SUFFIX;
        }
        channel.setName(name);
        return Optional.ofNullable(this.channelCache.putIfAbsent(name, channel)).orElse(channel);
    }

    protected String resolveDestination(String event, MessageEventStrategy.Channel channel) {
        String[] words = event.split("\\.");
        if (words.length != 3) {
            this.log.error("Event [{}]is not format,please use 'a.b.eventName' Format", (Object)event);
            return null;
        }
        String consumer = words[1];
        String producer = words[0];
        channel.setProducer(producer);
        channel.setConsumer(consumer);
        if ("all".equalsIgnoreCase(consumer)) {
            this.log.debug("Event[{}] is publish subscribable mode.", (Object)event);
            channel.setName(PUBLISH_SUBSCRIBABLE_EXCHANGE);
            channel.setPublishSubscribable(true);
            return PUBLISH_SUBSCRIBABLE_EXCHANGE;
        }
        channel.setName(consumer);
        return consumer;
    }

    protected String name(MessageEventStrategy.Channel channel, boolean producer) {
        return channel.getName();
    }

    boolean matchMemory(String event) {
        return this.memoryPredicate.test(event);
    }

    MessageEventStrategy.Channel resolveChannelFromName(String channelName) {
        return this.channelCache.get(channelName);
    }

    @Override
    public void fillBindingRule(String channelName, boolean producer) {
        MessageEventStrategy.Channel channel = this.resolveChannelFromName(channelName);
        Map bindingPropertiesMap = this.bindingServiceProperties.getBindings();
        BindingProperties bindingProperties = bindingPropertiesMap.computeIfAbsent(channelName, channelKey -> new BindingProperties());
        PropertyMapper map = PropertyMapper.get();
        map.from(channel::getDestination).whenNonNull().when(des -> StringUtils.isEmpty((CharSequence)bindingProperties.getDestination()) || StringUtils.equals((CharSequence)bindingProperties.getDestination(), (CharSequence)channelName)).to(arg_0 -> ((BindingProperties)bindingProperties).setDestination(arg_0));
        this.log.debug("Override channel[{}] binder type:{}.", (Object)channelName, (Object)channel.getType());
        map.from(channel::getType).whenNonNull().to(arg_0 -> ((BindingProperties)bindingProperties).setBinder(arg_0));
    }
}

