/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.rabbit;

import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.amqp.support.NackedAmqpMessageException;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ErrorMessage;

public class ErrorChannel
extends PublishSubscribeChannel {
    private static final Logger log = LoggerFactory.getLogger(ErrorChannel.class);

    public boolean subscribe(MessageHandler handler) {
        log.warn("\u4e0d\u5141\u8bb8\u6dfb\u52a0\u989d\u5916\u7684\u5904\u7406\u5668");
        return true;
    }

    public boolean unsubscribe(MessageHandler handler) {
        log.warn("\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u5904\u7406\u5668");
        return true;
    }

    public boolean send(@NonNull Message<?> message, long timeout) {
        ErrorMessage errorMessage;
        Object exc;
        log.error("Handle message exception,Message:{}", message);
        if (message instanceof ErrorMessage && (exc = (errorMessage = (ErrorMessage)message).getPayload()) instanceof NackedAmqpMessageException && log.isErrorEnabled()) {
            NackedAmqpMessageException exception = (NackedAmqpMessageException)errorMessage.getPayload();
            Message originMessage = exception.getFailedMessage();
            String msgId = MessageHeaderUtils.msgId(originMessage);
            log.error("Send Message msgId[{}],bizId[{}}] exception,cause by {}", new Object[]{msgId, MessageHeaderUtils.bizSeq(originMessage), exception.getNackReason()});
        }
        return true;
    }
}

