/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.persistent;

import cn.com.yusys.udp.cloud.message.persistent.MessageStore;
import cn.com.yusys.udp.cloud.message.persistent.constant.MessageType;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MessagePersistInvocationHandler
implements InvocationHandler {
    private static final String INTERCEPTOR_METHOD = "send";
    private final Logger log = LoggerFactory.getLogger(MessagePersistInvocationHandler.class);
    private final MessageChannel target;
    private final String channelName;
    private final MessageStore messageStore;

    public MessagePersistInvocationHandler(MessageChannel target, String channelName, MessageStore messageStore) {
        this.target = target;
        this.channelName = channelName;
        this.messageStore = messageStore;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (INTERCEPTOR_METHOD.equals(method.getName())) {
            Message<String> message = this.persist((Message)args[0]);
            return this.sendInternal(this.target, message);
        }
        return method.invoke((Object)this.target, args);
    }

    protected <T> Message<String> persist(Message<T> message) {
        Object payload = message.getPayload();
        Message stringMessage = MessageBuilder.withPayload((Object)MessageHeaderUtils.serialize(payload)).copyHeaders((Map)message.getHeaders()).build();
        if (MessageHeaderUtils.persist(stringMessage)) {
            this.log.debug("Persist Message via MessageStore.");
            this.messageStore.saveMessage(stringMessage, MessageType.SEND.getCode());
        }
        return stringMessage;
    }

    protected boolean sendInternal(MessageChannel channel, Message<?> message) {
        this.log.debug("Intercept channel [{}] [send] method.", (Object)this.channelName);
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return channel.send(message);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new MessageTransactionSynchronization(() -> channel.send(message)));
        return true;
    }

    static class MessageTransactionSynchronization
    implements TransactionSynchronization {
        private final Runnable runnable;

        public MessageTransactionSynchronization(Runnable runnable) {
            this.runnable = runnable;
        }

        public void afterCommit() {
            this.runnable.run();
        }
    }
}

