/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.exception;

import cn.com.yusys.udp.cloud.message.TriFunction;
import cn.com.yusys.udp.cloud.message.exception.PlatformException;
import cn.com.yusys.udp.cloud.message.i18n.MessageUtils;
import java.util.function.BiFunction;

public class TransformExceptionHelper {
    private TransformExceptionHelper() {
    }

    public static <T extends PlatformException> T createException(String messageCode, String defaultMessage, BiFunction<String, String, T> function, Object ... args) {
        String message = MessageUtils.getDefaultMessage(messageCode, defaultMessage, args);
        return (T)((PlatformException)function.apply(messageCode, message));
    }

    public static <T extends PlatformException> T createException(String messageCode, BiFunction<String, String, T> function, Object ... args) {
        String message = MessageUtils.getMessage(messageCode, args);
        return (T)((PlatformException)function.apply(messageCode, message));
    }

    public static <T extends PlatformException> T createException(Throwable e, String messageCode, TriFunction<String, String, Throwable, T> function, Object ... args) {
        String message = MessageUtils.getMessage(messageCode, args);
        return (T)((PlatformException)function.apply(messageCode, message, e));
    }

    public static PlatformException createException(Throwable e, String messageCode, Object ... args) {
        return TransformExceptionHelper.createException(e, messageCode, PlatformException::new, args);
    }

    public static PlatformException createException(String messageCode, Object ... args) {
        return TransformExceptionHelper.createException(messageCode, PlatformException::new, args);
    }
}

