/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer.processor;

import cn.com.yusys.udp.cloud.message.consumer.TransactionMessageEventDispatcher;
import cn.com.yusys.udp.cloud.message.consumer.processor.MessageEventProcess;
import cn.com.yusys.udp.cloud.message.util.QueueAckUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class CommonMessageEventProcess
implements MessageEventProcess {
    private static final Logger log = LoggerFactory.getLogger(CommonMessageEventProcess.class);
    private final InvocableHandlerMethod invocableHandlerMethod;
    private final TransactionMessageEventDispatcher transactionMessageEventDispatcher;

    public CommonMessageEventProcess(InvocableHandlerMethod invocableHandlerMethod, TransactionMessageEventDispatcher transactionMessageEventDispatcher) {
        this.invocableHandlerMethod = invocableHandlerMethod;
        this.transactionMessageEventDispatcher = transactionMessageEventDispatcher;
    }

    @Override
    public <T> void process(Message<T> message) {
        this.consumeMessage(message);
    }

    void consumeMessage(Message<?> message) {
        try {
            Object result = this.transactionMessageEventDispatcher.dispatchEvent(message, this.invocableHandlerMethod);
            log.debug("Biz Handle Success, result:{}", result);
            this.successHandle(message);
        }
        catch (Exception e) {
            this.consumerExceptionHandle(e, message);
            throw e;
        }
    }

    protected void successHandle(Message<?> message) {
    }

    protected void consumerExceptionHandle(Exception e, Message<?> message) {
        log.debug("Message consumer failure, reject message.");
        this.recordBizLog(e, message);
    }

    void recordBizLog(Exception e, Message<?> message) {
        QueueAckUtils.recordBizLog(e, message);
    }
}

