/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer.interceptor;

import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptor;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptorChain;
import cn.com.yusys.udp.cloud.message.consumer.processor.MessageEventProcess;
import cn.com.yusys.udp.cloud.message.exception.PlatformException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class InterceptorChainProxy {
    private static final Logger log = LoggerFactory.getLogger(InterceptorChainProxy.class);
    private final List<MessageEventInterceptor> interceptors;
    private final MessageEventProcess messageEventProcess;

    public InterceptorChainProxy(List<MessageEventInterceptor> interceptors, MessageEventProcess messageEventProcess) {
        this.interceptors = interceptors;
        this.messageEventProcess = messageEventProcess;
    }

    public void doHandle(Message<?> message) throws PlatformException {
        VirtualInterceptorChain chain = new VirtualInterceptorChain(this.interceptors, this.messageEventProcess);
        chain.doHandle(message);
    }

    static class VirtualInterceptorChain
    implements MessageEventInterceptorChain {
        private final List<MessageEventInterceptor> interceptors;
        private final MessageEventProcess messageEventProcess;
        private final int size;
        private int currentPosition = 0;

        public VirtualInterceptorChain(List<MessageEventInterceptor> interceptors, MessageEventProcess messageEventProcess) {
            this.interceptors = interceptors;
            this.messageEventProcess = messageEventProcess;
            this.size = interceptors.size();
        }

        @Override
        public void doHandle(Message<?> message) throws PlatformException {
            if (this.currentPosition == this.size) {
                this.messageEventProcess.process(message);
            } else {
                ++this.currentPosition;
                MessageEventInterceptor nextInterceptor = this.interceptors.get(this.currentPosition - 1);
                if (log.isDebugEnabled()) {
                    log.debug("Position:{} exec Interceptor:{}.", (Object)this.currentPosition, (Object)nextInterceptor);
                }
                nextInterceptor.doHandle(message, this);
            }
        }
    }
}

