/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer;

import cn.com.yusys.udp.cloud.message.exception.MessageConsumerException;
import cn.com.yusys.udp.cloud.message.persistent.MessageStore;
import cn.com.yusys.udp.cloud.message.persistent.constant.MessageType;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import java.util.function.Supplier;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.transaction.annotation.Transactional;

public class TransactionMessageEventDispatcher {
    private final MessageStore messageStore;

    public TransactionMessageEventDispatcher(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    @Transactional(rollbackFor={Exception.class})
    public void receiveMessage(Message<?> message) {
        if (MessageHeaderUtils.persist(message)) {
            this.messageStore.saveMessage(message, MessageType.RECEIVE.getCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Object dispatchEvent(Message<?> message, InvocableHandlerMethod invocableHandlerMethod) {
        return this.dispatchEvent(message, () -> {
            try {
                return invocableHandlerMethod.invoke(message, new Object[0]);
            }
            catch (Exception e) {
                throw MessageConsumerException.create(e, "MQ_C_001", invocableHandlerMethod.getMethod(), e.getMessage());
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public Object dispatchEvent(Message<?> message, Supplier<Object> supplier) {
        Object result = supplier.get();
        this.consumerSuccess(message);
        return result;
    }

    void consumerSuccess(Message<?> message) {
        if (MessageHeaderUtils.persist(message)) {
            this.messageStore.updateStatus(message, MessageType.RECEIVE.getCode());
        }
    }
}

