/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer;

import cn.com.yusys.udp.cloud.message.consumer.interceptor.InterceptorChainProxy;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import cn.com.yusys.udp.cloud.message.util.QueueAckUtils;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.AntPathMatcher;

public class MessageEventDispatcher
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(MessageEventDispatcher.class);
    private final AntPathMatcher antPathMatcher = new AntPathMatcher(".");
    private final Map<String, InterceptorChainProxy> chains;
    private Executor executor;

    public MessageEventDispatcher(Map<String, InterceptorChainProxy> chains) {
        this.chains = chains;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private void handle(Message<?> message, InterceptorChainProxy interceptorChainProxy) {
        if (this.executor != null) {
            this.executor.execute(() -> this.dispatch(message, interceptorChainProxy));
        } else {
            this.dispatch(message, interceptorChainProxy);
        }
    }

    void dispatch(Message<?> message, InterceptorChainProxy interceptorChainProxy) {
        try {
            interceptorChainProxy.doHandle(message);
        }
        catch (Throwable e) {
            log.error(String.format("Consumer event[%s] failure.", MessageHeaderUtils.event(message)), e);
        }
    }

    public void handleMessage(@NonNull Message<?> message) {
        String eventName;
        try {
            eventName = MessageHeaderUtils.event(message);
        }
        catch (Exception e) {
            log.error("missing Event name.", (Throwable)e);
            QueueAckUtils.nack(message, false);
            return;
        }
        AtomicBoolean matched = new AtomicBoolean(false);
        this.chains.forEach((event, chainProxy) -> {
            if (this.antPathMatcher.match(event, eventName)) {
                matched.set(true);
                log.debug("Consumer[{}] begin to handle event:[{}].", event, (Object)eventName);
                this.handle(message, (InterceptorChainProxy)chainProxy);
            }
        });
        if (!matched.get()) {
            log.warn("event:{} not exists listener, please check event is right.", (Object)eventName);
            QueueAckUtils.nack(message, false);
        }
    }
}

