/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config.rabbit;

import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokerProperties;
import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokersProperties;
import cn.com.yusys.udp.cloud.message.exception.MessageException;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

public class RabbitPropertiesPostProcessor
implements BeanPostProcessor,
EnvironmentAware {
    private Environment environment;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) {
        BindResult result;
        Class rabbit = AopUtils.getTargetClass((Object)bean);
        if (RabbitProperties.class.isAssignableFrom(rabbit) && (result = Binder.get((Environment)this.environment).bind("udp.message.rabbitmq", RabbitBrokersProperties.class)).isBound()) {
            RabbitBrokersProperties brokersProperties = (RabbitBrokersProperties)result.get();
            Map<String, RabbitBrokerProperties> brokersMap = brokersProperties.getBrokers();
            if (brokersMap.isEmpty()) {
                throw new MessageException(String.format("miss rabbitmq brokers config.please configure : %s.", "udp.message.rabbitmq"));
            }
            return brokersMap.values().iterator().next();
        }
        return bean;
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }
}

