/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config.event;

import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokersProperties;
import cn.com.yusys.udp.cloud.message.channel.factory.ChannelFactory;
import cn.com.yusys.udp.cloud.message.config.event.DynamicBindable;
import cn.com.yusys.udp.cloud.message.config.event.MessageEventHandlerPostProcessor;
import cn.com.yusys.udp.cloud.message.config.event.MessageEventProperties;
import cn.com.yusys.udp.cloud.message.consumer.TransactionMessageEventDispatcher;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.ConcurrencyLimitInterceptorFactory;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.StoreMessageInterceptorFactory;
import cn.com.yusys.udp.cloud.message.consumer.processor.CommonMessageEventProcessFactory;
import cn.com.yusys.udp.cloud.message.consumer.processor.MessageEventProcessFactory;
import cn.com.yusys.udp.cloud.message.persistent.MessageStore;
import cn.com.yusys.udp.cloud.message.rule.MessageEventBindingService;
import cn.com.yusys.udp.cloud.message.rule.MessageEventStrategy;
import cn.com.yusys.udp.cloud.message.rule.impl.DefaultMessageEventStrategy;
import cn.com.yusys.udp.cloud.message.rule.impl.MessageEventBindingServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.transaction.PlatformTransactionManager;

@EnableConfigurationProperties(value={MessageEventProperties.class, BindingServiceProperties.class, RabbitBrokersProperties.class})
public class MessageEventAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MessageEventStrategy messageEventStrategy(MessageEventProperties messageEventProperties, BindingServiceProperties bindingServiceProperties) {
        return new DefaultMessageEventStrategy(messageEventProperties.getMemory(), bindingServiceProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageEventProcessFactory messageEventProcessFactory(MessageHandlerMethodFactory integrationMessageHandlerMethodFactory, TransactionMessageEventDispatcher transactionMessageEventDispatcher) {
        return new CommonMessageEventProcessFactory(integrationMessageHandlerMethodFactory, transactionMessageEventDispatcher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageEventBindingService messageEventBindingService(MessageEventStrategy messageEventStrategy, ChannelFactory channelFactory) {
        return new MessageEventBindingServiceImpl(channelFactory, messageEventStrategy);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageEventHandlerPostProcessor messageEventHandlerPostProcessor() {
        return new MessageEventHandlerPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConcurrencyLimitInterceptorFactory concurrencyLimitInterceptorFactory() {
        return new ConcurrencyLimitInterceptorFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public StoreMessageInterceptorFactory storeMessageInterceptorFactory(TransactionMessageEventDispatcher transactionMessageEventDispatcher) {
        return new StoreMessageInterceptorFactory(transactionMessageEventDispatcher);
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicBindable dynamicBindable() {
        return new DynamicBindable();
    }

    @ConditionalOnClass(value={PlatformTransactionManager.class})
    static class MessageEventTransactionConfiguration {
        MessageEventTransactionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TransactionMessageEventDispatcher transactionMessageEventDispatcher(MessageStore messageStore) {
            return new TransactionMessageEventDispatcher(messageStore);
        }
    }
}

