/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config;

import cn.com.yusys.udp.cloud.message.MqPublisher;
import cn.com.yusys.udp.cloud.message.channel.BindingTargetFactoryBeanPostProcessor;
import cn.com.yusys.udp.cloud.message.channel.ChannelBeanPostProcessor;
import cn.com.yusys.udp.cloud.message.channel.YuChannelBeanPostProcessor;
import cn.com.yusys.udp.cloud.message.config.BindingConfiguration;
import cn.com.yusys.udp.cloud.message.constant.MessageConstants;
import cn.com.yusys.udp.cloud.message.consumer.channel.ConsumerExceptionChannelInterceptor;
import cn.com.yusys.udp.cloud.message.persistent.ConfirmChannel;
import cn.com.yusys.udp.cloud.message.persistent.MessageSequenceHelper;
import cn.com.yusys.udp.cloud.message.persistent.MessageStore;
import cn.com.yusys.udp.cloud.message.persistent.impl.DefaultMessageSequenceHelper;
import cn.com.yusys.udp.cloud.message.persistent.impl.DefaultMessageStore;
import cn.com.yusys.udp.cloud.message.rule.publish.BindingMessageQueueHelper;
import cn.com.yusys.udp.cloud.message.rule.publish.MessageQueueHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper;
import org.springframework.messaging.support.ChannelInterceptor;

@ConditionalOnClass(value={MqPublisher.class})
@EnableBinding
@Import(value={BindingConfiguration.class})
public class MessageAutoConfiguration {
    private final Logger log = LoggerFactory.getLogger(MessageAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public MessageSequenceHelper messageBuilder(Environment environment) {
        return new DefaultMessageSequenceHelper(environment.getProperty("spring.application.name"));
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageQueueHelper messageQueueHelper() {
        return new BindingMessageQueueHelper();
    }

    @Autowired
    public void initMqPublisher(MessageQueueHelper messageQueueHelper) {
        this.log.debug("Init Message uniform publisher");
        MqPublisher.setMessageQueueHelper(messageQueueHelper);
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageStore.class})
    public MessageStore defaultMessageStore() {
        this.log.debug("Init DbMessageStore that log message in console");
        return new DefaultMessageStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public BindingTargetFactoryBeanPostProcessor bindingTargetFactoryBeanPostProcessor(ObjectProvider<List<ChannelBeanPostProcessor>> channelProvider) {
        this.log.debug("Init BindingTargetFactoryBeanPostProcessor with ChannelBeanPostProcessor List.");
        List channelBeanPostProcessors = (List)channelProvider.getIfAvailable();
        return new BindingTargetFactoryBeanPostProcessor(channelBeanPostProcessors);
    }

    @Bean
    @ConditionalOnMissingBean
    public YuChannelBeanPostProcessor channelBeanPostProcessor() {
        this.log.debug("Add ChannelBeanPostProcessor.");
        return new YuChannelBeanPostProcessor();
    }

    @Bean(value={"confirmChannel"})
    @ConditionalOnMissingBean
    public ConfirmChannel confirmChannel(MessageStore messageStore) {
        this.log.debug("Init Rabbit publish confirm channel,it will save message send status to db.");
        return new ConfirmChannel(messageStore);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerExceptionChannelInterceptor consumerExceptionChannelInterceptor() {
        return new ConsumerExceptionChannelInterceptor();
    }

    @Bean
    public GlobalChannelInterceptorWrapper consumerExceptionChannelInterceptorWrapper(ConsumerExceptionChannelInterceptor interceptor) {
        GlobalChannelInterceptorWrapper wrapper = new GlobalChannelInterceptorWrapper((ChannelInterceptor)interceptor);
        wrapper.setOrder(-2147483638);
        wrapper.setPatterns(MessageConstants.MSG_TRACE_CHANNELS);
        return wrapper;
    }
}

