/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.channel;

import cn.com.yusys.udp.cloud.message.channel.ChannelBeanPostProcessor;
import cn.com.yusys.udp.cloud.message.channel.ChannelRegistry;
import cn.com.yusys.udp.cloud.message.persistent.MessagePersistInvocationHandler;
import cn.com.yusys.udp.cloud.message.persistent.MessageStore;
import cn.com.yusys.udp.cloud.message.util.ProxyUtils;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.lang.NonNull;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;

public class YuChannelBeanPostProcessor
implements ChannelBeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(YuChannelBeanPostProcessor.class);
    private ApplicationContext context;
    private MessageStore messageStore;

    private void init(String name, Object channel) {
        Assert.notNull((Object)this.context, (String)"ApplicationContext Not Init.");
        this.messageStore = (MessageStore)this.context.getBean(MessageStore.class);
        if (channel instanceof AbstractMessageChannel) {
            AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
            messageChannel.setComponentName(name);
            messageChannel.setApplicationContext(this.context);
        }
    }

    public Object postProcessInputAfterCreate(String name, Object input) {
        this.init(name, input);
        Object proxy = this.proxyInputChannel(name, input);
        if (proxy instanceof SubscribableChannel) {
            ChannelRegistry.registerInput(name, (SubscribableChannel)proxy);
        }
        return proxy;
    }

    private Object proxyInputChannel(String name, Object input) {
        log.debug("Proxy input Channel \uff1a{} with Subscribe", (Object)name);
        return input;
    }

    public Object postProcessOutputAfterCreate(String name, Object output) {
        this.init(name, output);
        Object proxy = this.proxyOutputChannel(output, name);
        if (proxy instanceof MessageChannel) {
            ChannelRegistry.registerOutput(name, (MessageChannel)proxy);
        }
        return proxy;
    }

    private Object proxyOutputChannel(Object target, String beanName) {
        if (target instanceof MessageChannel && !beanName.startsWith("virtual")) {
            log.debug("Proxy output Channel\uff1a{} with ChannelProxy", (Object)beanName);
            MessagePersistInvocationHandler handler = this.proxy((MessageChannel)target, beanName);
            return ProxyUtils.proxyMessageChannel(target, (Advice)((MethodInterceptor)invocation -> handler.invoke(invocation.getThis(), invocation.getMethod(), invocation.getArguments())));
        }
        return target;
    }

    private MessagePersistInvocationHandler proxy(MessageChannel channel, String channelName) {
        return new MessagePersistInvocationHandler(channel, channelName, this.messageStore);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}

