/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.channel;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

public class ChannelRegistry {
    private static final Map<String, MessageChannel> OUTPUT_CHANNELS = new ConcurrentHashMap<String, MessageChannel>();
    private static final Map<String, SubscribableChannel> INPUT_CHANNELS = new ConcurrentHashMap<String, SubscribableChannel>();
    private static final Map<String, SubscribableChannel> DYNAMIC_INPUTS = new ConcurrentHashMap<String, SubscribableChannel>();

    private ChannelRegistry() {
    }

    public static void registerOutput(String channelName, MessageChannel messageChannel) {
        OUTPUT_CHANNELS.put(channelName, messageChannel);
    }

    public static void registerInput(String channelName, SubscribableChannel subscribableChannel) {
        INPUT_CHANNELS.put(channelName, subscribableChannel);
    }

    public static MessageChannel output(String name) {
        return OUTPUT_CHANNELS.get(name);
    }

    public static SubscribableChannel input(String name) {
        return INPUT_CHANNELS.get(name);
    }

    public static void registerDynamicInput(String input, SubscribableChannel subscribableChannel) {
        DYNAMIC_INPUTS.put(input, subscribableChannel);
    }

    public static Map<String, SubscribableChannel> dynamicInputs() {
        return Collections.unmodifiableMap(DYNAMIC_INPUTS);
    }
}

