/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.channel;

import cn.com.yusys.udp.cloud.message.channel.BindingTargetFactoryAdapter;
import cn.com.yusys.udp.cloud.message.channel.ChannelBeanPostProcessor;
import cn.com.yusys.udp.cloud.message.exception.PlatformException;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.NonNull;

public class BindingTargetFactoryBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BindingTargetFactoryBeanPostProcessor.class);
    private final List<ChannelBeanPostProcessor> channelBeanPostProcessors;
    private ConfigurableApplicationContext applicationContext;

    public BindingTargetFactoryBeanPostProcessor(List<ChannelBeanPostProcessor> channelBeanPostProcessors) {
        this.channelBeanPostProcessors = channelBeanPostProcessors;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) {
        if (bean instanceof AbstractBindingTargetFactory) {
            log.info("Post processor BindingTargetFactory:{}", (Object)beanName);
            Class type = this.getClassType(bean);
            return new BindingTargetFactoryAdapter(type, (AbstractBindingTargetFactory)bean, this.channelBeanPostProcessors, this.applicationContext);
        }
        return bean;
    }

    <T> Class<T> getClassType(Object bindingTargetFactory) {
        try {
            return (Class)ReflectionUtils.getPropertyValue((Object)bindingTargetFactory, (String)"bindingTargetType");
        }
        catch (Exception e) {
            throw new PlatformException(" Missing bindTargetType", e);
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }
}

