/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.channel;

import cn.com.yusys.udp.cloud.message.channel.ChannelBeanPostProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class BindingTargetFactoryAdapter<T>
extends AbstractBindingTargetFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(BindingTargetFactoryAdapter.class);
    private final AbstractBindingTargetFactory<T> delegate;
    private final List<ChannelBeanPostProcessor> channelBeanPostProcessors;
    private final ConfigurableApplicationContext applicationContext;

    public BindingTargetFactoryAdapter(Class<T> bindingTargetType, AbstractBindingTargetFactory<T> delegate, List<ChannelBeanPostProcessor> channelBeanPostProcessors, ConfigurableApplicationContext context) {
        super(bindingTargetType);
        this.delegate = delegate;
        this.channelBeanPostProcessors = channelBeanPostProcessors;
        this.applicationContext = context;
    }

    public T createInput(String name) {
        return (T)this.postProcessInput(name, this.delegate.createInput(name));
    }

    private T postProcessInput(String name, T target) {
        log.debug("Post processor input channel :{}.", (Object)name);
        T instance = this.instantiateChannel(name, target);
        if (this.channelBeanPostProcessors != null && !this.channelBeanPostProcessors.isEmpty()) {
            for (ChannelBeanPostProcessor channelBeanPostProcessor : this.channelBeanPostProcessors) {
                instance = channelBeanPostProcessor.postProcessInputAfterCreate(name, instance);
            }
        }
        return instance;
    }

    private T instantiateChannel(String name, T target) {
        if (!this.applicationContext.containsBean(name)) {
            this.applicationContext.getBeanFactory().registerSingleton(name, target);
            return (T)this.applicationContext.getAutowireCapableBeanFactory().initializeBean(target, name);
        }
        return target;
    }

    public T createOutput(String name) {
        return (T)this.postProcessOutput(name, this.delegate.createOutput(name));
    }

    private T postProcessOutput(String name, T target) {
        log.debug("Post processor output channel:{}.", (Object)name);
        T instance = this.instantiateChannel(name, target);
        if (this.channelBeanPostProcessors != null && !this.channelBeanPostProcessors.isEmpty()) {
            for (ChannelBeanPostProcessor channelBeanPostProcessor : this.channelBeanPostProcessors) {
                instance = channelBeanPostProcessor.postProcessOutputAfterCreate(name, instance);
            }
        }
        return instance;
    }
}

