/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.broker.health;

import cn.com.yusys.udp.cloud.message.broker.ConnectionFactoryListener;
import com.rabbitmq.client.Channel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class RabbitBrokersHealthIndicator
extends AbstractHealthIndicator
implements ConnectionFactoryListener {
    private final Map<String, ConnectionFactory> connectionFactories = new ConcurrentHashMap<String, ConnectionFactory>();

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        HashMap serverStatus = new HashMap();
        this.connectionFactories.forEach((name, connectionFactory) -> {
            Connection connection = null;
            Channel channel = null;
            try {
                connection = connectionFactory.createConnection();
                channel = connection.createChannel(false);
                Map server = channel.getConnection().getServerProperties();
                serverStatus.put(name, Collections.singletonMap("version", server.get("version")));
            }
            catch (Throwable throwable) {
                RabbitUtils.closeChannel(channel);
                RabbitUtils.closeConnection((Connection)connection);
                throw throwable;
            }
            RabbitUtils.closeChannel((Channel)channel);
            RabbitUtils.closeConnection((Connection)connection);
        });
        builder.up().withDetails(serverStatus).build();
    }

    @Override
    public void onCreate(String name, ConnectionFactory connectionFactory) {
        this.connectionFactories.putIfAbsent(name, connectionFactory);
    }
}

