/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.strategy.interceptor;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AddHeaderRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest inputRequest = attributes.getRequest();
        String udpVersion = inputRequest.getHeader("X-Udp-Version");
        String udpRegion = inputRequest.getHeader("X-Udp-Region");
        String udpFaultTolerant = inputRequest.getHeader("X-Udp-Fault-Tolerant");
        if (udpVersion != null) {
            request.getHeaders().add("X-Udp-Version", udpVersion);
        }
        if (udpRegion != null) {
            request.getHeaders().add("X-Udp-Region", udpRegion);
        }
        if (udpFaultTolerant != null) {
            request.getHeaders().add("X-Udp-Fault-Tolerant", udpFaultTolerant);
        }
        return execution.execute(request, body);
    }
}

