/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.strategy;

import cn.com.yusys.udp.cloud.strategy.UcReleaseStrategyProperties;
import cn.com.yusys.udp.cloud.strategy.interceptor.AddHeaderFeignInterceptor;
import cn.com.yusys.udp.cloud.strategy.interceptor.AddHeaderRestTemplateInterceptor;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={UcReleaseStrategyProperties.class})
@ConditionalOnProperty(name={"udp.cloud.release-strategy.enabled"}, havingValue="true")
@AutoConfigureBefore(value={LoadBalancerAutoConfiguration.class})
public class UcReleaseStrategyAutoConfiguration {
    @LoadBalanced
    @Autowired(required=false)
    List<RestTemplate> restTemplates = Collections.emptyList();

    @Bean
    public SmartInitializingSingleton customRestTemplateInitializer() {
        return () -> this.restTemplates.forEach(restTemplate -> {
            ArrayList<AddHeaderRestTemplateInterceptor> list = new ArrayList<AddHeaderRestTemplateInterceptor>(restTemplate.getInterceptors());
            list.add(new AddHeaderRestTemplateInterceptor());
            restTemplate.setInterceptors(list);
        });
    }

    @Bean
    public RequestInterceptor addHeaderFeignInterceptor() {
        return new AddHeaderFeignInterceptor();
    }
}

