/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.rule;

import cn.com.yusys.udp.cloud.lb.rule.IRule;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;

public class UcRoundRobinRule
extends IRule {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final AtomicInteger position = new AtomicInteger(new Random().nextInt(1000));

    public UcRoundRobinRule(String serviceId) {
        super(serviceId);
    }

    @Override
    public Response<ServiceInstance> getInstanceResponse(Request request, List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No servers available for service: " + this.serviceId);
            }
            return new EmptyResponse();
        }
        int pos = this.position.incrementAndGet() & Integer.MAX_VALUE;
        ServiceInstance instance = instances.get(pos % instances.size());
        return new DefaultResponse(instance);
    }
}

