/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.rule;

import cn.com.yusys.udp.cloud.lb.rule.IRule;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;

public class UcRandomRule
extends IRule {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public UcRandomRule(String serviceId) {
        super(serviceId);
    }

    @Override
    public Response<ServiceInstance> getInstanceResponse(Request request, List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No servers available for service: " + this.serviceId);
            }
            return new EmptyResponse();
        }
        int index = ThreadLocalRandom.current().nextInt(instances.size());
        ServiceInstance instance = instances.get(index);
        return new DefaultResponse(instance);
    }
}

