/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.rule;

import cn.com.yusys.udp.cloud.lb.rule.IRule;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;

public class UcDevRule
extends IRule {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TARGET_HEADER_KEY = "instance-prefer";

    public UcDevRule(String serviceId) {
        super(serviceId);
    }

    @Override
    public Response<ServiceInstance> getInstanceResponse(Request request, List<ServiceInstance> instances) {
        RequestDataContext context;
        String prefer;
        if (instances.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No servers available for service: " + this.serviceId);
            }
            return new EmptyResponse();
        }
        if (request.getContext() instanceof RequestDataContext && (prefer = (context = (RequestDataContext)request.getContext()).getClientRequest().getHeaders().getFirst(TARGET_HEADER_KEY)) != null) {
            for (ServiceInstance instance : instances) {
                if (!prefer.equals(instance.getHost() + ":" + instance.getPort())) continue;
                this.logger.trace("dev instance: {}:{}", (Object)instance.getHost(), (Object)("" + instance.getPort()));
                return new DefaultResponse(instance);
            }
            for (ServiceInstance instance : instances) {
                if (!prefer.equals(instance.getHost())) continue;
                this.logger.trace("dev instance: {}:{}", (Object)instance.getHost(), (Object)("" + instance.getPort()));
                return new DefaultResponse(instance);
            }
        }
        int index = ThreadLocalRandom.current().nextInt(instances.size());
        ServiceInstance instance = instances.get(index);
        this.logger.trace("random instance: {}:{}", (Object)instance.getHost(), (Object)("" + instance.getPort()));
        return new DefaultResponse(instance);
    }
}

