/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.loadbalancer;

import cn.com.yusys.udp.cloud.commons.constant.RouteType;
import cn.com.yusys.udp.cloud.commons.util.JsonUtil;
import cn.com.yusys.udp.cloud.lb.rule.IRule;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public class UcReactorServiceInstanceLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final IRule iRule;
    private final Environment environment;

    public UcReactorServiceInstanceLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, IRule iRule, Environment environment) {
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.iRule = iRule;
        this.environment = environment;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> {
            List<ServiceInstance> filteredServiceInstances = this.getGrayInstances((List<ServiceInstance>)serviceInstances, request);
            Response<ServiceInstance> serviceInstanceResponse = this.iRule.getInstanceResponse(request, filteredServiceInstances);
            if (supplier instanceof SelectedInstanceCallback && serviceInstanceResponse.hasServer()) {
                ((SelectedInstanceCallback)supplier).selectedServiceInstance((ServiceInstance)serviceInstanceResponse.getServer());
            }
            return serviceInstanceResponse;
        });
    }

    public IRule getIRule() {
        return this.iRule;
    }

    private List<ServiceInstance> getGrayInstances(List<ServiceInstance> instances, Request request) {
        if (CollectionUtils.isEmpty(instances)) {
            return instances;
        }
        boolean isGrayEnabled4Gateway = Boolean.TRUE.equals(this.environment.getProperty("udp.cloud.gateway.release-strategy.enabled", Boolean.TYPE));
        boolean isGrayEnabled4Client = Boolean.TRUE.equals(this.environment.getProperty("udp.cloud.release-strategy.enabled", Boolean.TYPE));
        if (isGrayEnabled4Gateway || isGrayEnabled4Client) {
            RequestDataContext context = (RequestDataContext)request.getContext();
            HttpHeaders headers = context.getClientRequest().getHeaders();
            return this.isStrategyMatch(headers) ? this.getMatchedInstances(instances, headers) : instances;
        }
        return instances;
    }

    private boolean isStrategyMatch(HttpHeaders headers) {
        return headers.getFirst("X-Udp-Region") != null || headers.getFirst("X-Udp-Version") != null;
    }

    private List<ServiceInstance> getMatchedInstances(List<ServiceInstance> instances, HttpHeaders headers) {
        List<ServiceInstance> matchServers;
        String udpVersion = headers.getFirst("X-Udp-Version");
        String udpRegion = headers.getFirst("X-Udp-Region");
        if (udpVersion != null) {
            udpVersion = udpVersion.replace("%7B", "{").replace("%7D", "}");
            matchServers = this.filterInstancesByHeader(instances, RouteType.VERSION, udpVersion);
        } else {
            if (udpRegion != null) {
                udpRegion = udpRegion.replace("%7B", "{").replace("%7D", "}");
            }
            matchServers = this.filterInstancesByHeader(instances, RouteType.REGION, udpRegion);
        }
        if (CollectionUtils.isEmpty(matchServers)) {
            boolean faultTolerant = Boolean.parseBoolean(headers.getFirst("X-Udp-Fault-Tolerant"));
            if (faultTolerant) {
                return instances;
            }
            this.logger.warn("[udp-cloud] can not find match service instance by udp release strategy");
            return matchServers;
        }
        return matchServers;
    }

    List<ServiceInstance> filterInstancesByHeader(List<ServiceInstance> instances, RouteType routeType, String headerValue) {
        String value;
        ArrayList<ServiceInstance> filterServers = new ArrayList<ServiceInstance>();
        String appName = instances.get(0).getServiceId();
        Map map = (Map)JsonUtil.toObject((String)headerValue, (TypeReference)new TypeReference<Map<String, String>>(){});
        String string = value = map == null ? null : (String)map.get(appName);
        if (value == null) {
            return instances;
        }
        for (ServiceInstance instance : instances) {
            Map metadata = instance.getMetadata();
            if (!value.equals(metadata.get(routeType.getMetadataName()))) continue;
            filterServers.add(instance);
        }
        return filterServers;
    }
}

