/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.loadbalancer;

import cn.com.yusys.udp.cloud.lb.UcLoadBalancerProperties;
import cn.com.yusys.udp.cloud.lb.loadbalancer.UcReactorServiceInstanceLoadBalancer;
import cn.com.yusys.udp.cloud.lb.rule.IRule;
import cn.com.yusys.udp.cloud.lb.rule.UcRoundRobinRule;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class UcLoadBalancerClientConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public ReactorLoadBalancer<ServiceInstance> reactorServiceInstanceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, DefaultListableBeanFactory beanFactory, UcLoadBalancerProperties properties) {
        String name = environment.getProperty("loadbalancer.client.name");
        IRule iRule = this.newRule(name, beanFactory, properties);
        if (iRule == null) {
            iRule = new UcRoundRobinRule(name);
        }
        this.logger.info("[udp-cloud]: iRule {}={}", (Object)name, (Object)iRule.getClass().getName());
        return new UcReactorServiceInstanceLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), iRule, environment);
    }

    private IRule newRule(String name, DefaultListableBeanFactory beanFactory, UcLoadBalancerProperties properties) {
        String ruleClazz = null;
        try {
            ruleClazz = properties.getRuleClassNames().get(name);
            if (ruleClazz == null) {
                ruleClazz = properties.getDefaultRuleClassName();
            }
            if (ruleClazz == null) {
                return null;
            }
            Constructor<?> constructor = Class.forName(ruleClazz).getConstructor(String.class);
            IRule iRule = (IRule)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{name});
            beanFactory.autowireBean((Object)iRule);
            return iRule;
        }
        catch (Exception e) {
            this.logger.error("[udp-cloud]: iRule [{}] instantiate error", (Object)ruleClazz, (Object)e);
            return null;
        }
    }
}

