/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb;

import cn.com.yusys.udp.cloud.lb.UcLoadBalancerProperties;
import cn.com.yusys.udp.cloud.lb.loadbalancer.UcLoadBalancerClientConfiguration;
import cn.com.yusys.udp.cloud.lb.loadbalancer.UcLoadbalancerRefreshEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerBeanPostProcessorAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;

@AutoConfigureBefore(value={ReactorLoadBalancerClientAutoConfiguration.class, LoadBalancerBeanPostProcessorAutoConfiguration.class, LoadBalancerAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.loadbalancer.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcLoadBalancerProperties.class})
@LoadBalancerClients(defaultConfiguration={UcLoadBalancerClientConfiguration.class})
public class UcLoadBalancerAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UcLoadbalancerRefreshEventHandler ucLoadbalancerRefreshEventHandler;

    @Bean
    @ConditionalOnMissingBean
    public UcLoadbalancerRefreshEventHandler ucLoadbalancerRefreshEventHandler() {
        this.ucLoadbalancerRefreshEventHandler = new UcLoadbalancerRefreshEventHandler();
        this.logger.info("[udp-cloud]: register UcLoadbalancerRefreshEventHandler");
        return this.ucLoadbalancerRefreshEventHandler;
    }

    @EventListener(classes={EnvironmentChangeEvent.class})
    public void handleLoadbRefreshEvent(EnvironmentChangeEvent event) {
        if (this.ucLoadbalancerRefreshEventHandler != null) {
            this.ucLoadbalancerRefreshEventHandler.exec(event);
        }
    }
}

