/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class UcPropertiesFactory
extends PropertiesFactory {
    @Autowired
    private Environment environment;
    private Map<Class, String> classToProperty = new HashMap<Class, String>();

    public UcPropertiesFactory() {
        this.classToProperty.put(ILoadBalancer.class, "NFLoadBalancerClassName");
        this.classToProperty.put(IPing.class, "NFLoadBalancerPingClassName");
        this.classToProperty.put(IRule.class, "NFLoadBalancerRuleClassName");
        this.classToProperty.put(ServerList.class, "NIWSServerListClassName");
        this.classToProperty.put(ServerListFilter.class, "NIWSServerListFilterClassName");
    }

    public String getClassName(Class clazz, String name) {
        if (this.classToProperty.containsKey(clazz)) {
            String classNameProperty = this.classToProperty.get(clazz);
            String className = this.environment.getProperty(name + "." + "ribbon" + "." + classNameProperty);
            if (className == null) {
                className = this.environment.getProperty("ribbon." + classNameProperty);
            }
            return className;
        }
        return null;
    }

    public <C> C get(Class<C> clazz, IClientConfig config, String name) {
        String className = this.getClassName(clazz, name);
        if (StringUtils.hasText((String)className)) {
            try {
                Class<?> toInstantiate = Class.forName(className);
                return (C)SpringClientFactory.instantiateWithConfig(toInstantiate, (IClientConfig)config);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unknown class to load " + className + " for class " + clazz + " named " + name);
            }
        }
        return null;
    }
}

