/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.ribbon;

import cn.com.yusys.udp.cloud.lb.feign.UcCachingSpringLoadBalancerFactory;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class UcRibbonRefreshEventHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected SpringClientFactory springClientFactory;
    @Autowired(required=false)
    protected UcCachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;

    public synchronized void exec(EnvironmentChangeEvent event) {
        Set keys = event.getKeys();
        boolean ribbonChanged = false;
        for (String key : keys) {
            if (!key.contains("ribbon.")) continue;
            this.logger.info("[udp-cloud]: ribbon refreshed {}", (Object)key);
            ribbonChanged = true;
        }
        if (ribbonChanged) {
            this.logger.info("[udp-cloud]: ribbon destroy contexts {}", (Object)this.springClientFactory.getContextNames());
            this.springClientFactory.destroy();
            if (this.cachingSpringLoadBalancerFactory != null) {
                this.cachingSpringLoadBalancerFactory.destroy();
            }
        }
    }
}

