/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb.ribbon;

import cn.com.yusys.udp.cloud.lb.ribbon.UcWrapRule;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class UcRibbonClientConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @RibbonClientName
    private String name = "client";
    @Autowired
    private PropertiesFactory propertiesFactory;
    @Autowired
    private DefaultListableBeanFactory beanFactory;

    @Bean
    public IRule ribbonRule(IClientConfig config) {
        IRule iRule = (IRule)this.propertiesFactory.get(IRule.class, config, this.name);
        if (iRule == null) {
            iRule = new ZoneAvoidanceRule();
        }
        this.beanFactory.autowireBean((Object)iRule);
        this.logger.info("[udp-cloud]: iRule {}={}", (Object)this.name, (Object)iRule.getClass().getName());
        UcWrapRule wrapRule = new UcWrapRule();
        wrapRule.setRule(iRule);
        wrapRule.initWithNiwsConfig(config);
        return wrapRule;
    }
}

