/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.lb;

import cn.com.yusys.udp.cloud.lb.feign.UcCachingSpringLoadBalancerFactory;
import cn.com.yusys.udp.cloud.lb.ribbon.UcRibbonRefreshEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.ribbon.UcPropertiesFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.FeignRibbonClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;

@ConditionalOnClass(value={RibbonClient.class, FeignClient.class})
@ConditionalOnProperty(name={"udp.cloud.load-balancer-enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={RibbonAutoConfiguration.class, FeignRibbonClientAutoConfiguration.class})
public class UcLoadBalancerAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UcRibbonRefreshEventHandler ribbonRefreshEventHandler;

    @Bean
    public UcPropertiesFactory propertiesFactory() {
        return new UcPropertiesFactory();
    }

    @Bean
    @Primary
    public CachingSpringLoadBalancerFactory cachingLBClientFactory(SpringClientFactory factory) {
        this.logger.info("[udp-cloud]: register UcCachingSpringLoadBalancerFactory");
        return new UcCachingSpringLoadBalancerFactory(factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcRibbonRefreshEventHandler ucRibbonRefreshEventHandler() {
        this.ribbonRefreshEventHandler = new UcRibbonRefreshEventHandler();
        this.logger.info("[udp-cloud]: register UcRibbonRefreshEventHandler");
        return this.ribbonRefreshEventHandler;
    }

    @EventListener(classes={EnvironmentChangeEvent.class})
    public void handleRibbonRefreshEvent(EnvironmentChangeEvent event) {
        if (this.ribbonRefreshEventHandler != null) {
            this.ribbonRefreshEventHandler.exec(event);
        }
    }
}

