/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.util;

import cn.com.yusys.udp.cloud.commons.util.UcCryptoUtils;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.SM4;
import java.security.KeyPair;
import java.util.Arrays;

public class UcgCryptoUtils
extends UcCryptoUtils {
    public static byte[] toByteFix(String value, int length) {
        byte[] rtValue;
        try {
            rtValue = Arrays.copyOf(value.getBytes(), length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rtValue;
    }

    public static UcgKeyPair rsaGenKey() {
        KeyPair pair = SecureUtil.generateKeyPair((String)"RSA");
        return new UcgKeyPair(pair.getPrivate().getEncoded(), pair.getPublic().getEncoded());
    }

    public static byte[] rsaEncode(byte[] data, byte[] publicKey) {
        RSA rsaE = SecureUtil.rsa(null, (byte[])publicKey);
        return rsaE.encrypt(data, KeyType.PublicKey);
    }

    public static byte[] rsaDecode(byte[] bytes, byte[] privateKey) {
        RSA rsaD = SecureUtil.rsa((byte[])privateKey, null);
        return rsaD.decrypt(bytes, KeyType.PrivateKey);
    }

    public static byte[] aesEncode(byte[] data, byte[] key) {
        AES aes = SecureUtil.aes((byte[])key);
        return aes.encrypt(data);
    }

    public static byte[] aesDecode(byte[] bytes, byte[] key) {
        AES aes = SecureUtil.aes((byte[])key);
        return aes.decrypt(bytes);
    }

    public static UcgKeyPair sm2GenKey() {
        KeyPair pair = SecureUtil.generateKeyPair((String)"SM2");
        return new UcgKeyPair(pair.getPrivate().getEncoded(), pair.getPublic().getEncoded());
    }

    public static byte[] sm2DecodeFix(byte[] bytes) {
        if (bytes[0] != 4) {
            byte[] newBytes = new byte[bytes.length + 1];
            newBytes[0] = 4;
            System.arraycopy(bytes, 0, newBytes, 1, bytes.length);
            return newBytes;
        }
        return bytes;
    }

    public static byte[] sm2EncodeFix(byte[] bytes) {
        if (bytes[0] == 4) {
            byte[] newBytes = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, newBytes, 0, bytes.length - 1);
            return newBytes;
        }
        return bytes;
    }

    public static byte[] sm2Encode(byte[] data, byte[] publicKey) {
        SM2 sm2E = SmUtil.sm2(null, (byte[])publicKey);
        return sm2E.encrypt(data, KeyType.PublicKey);
    }

    public static byte[] sm2Decode(byte[] bytes, byte[] privateKey) {
        SM2 sm2D = SmUtil.sm2((byte[])privateKey, null);
        return sm2D.decrypt(bytes, KeyType.PrivateKey);
    }

    public static byte[] sm4Encode(byte[] data, byte[] key) {
        SM4 sm4 = SmUtil.sm4((byte[])key);
        return sm4.encrypt(data);
    }

    public static byte[] sm4Decode(byte[] bytes, byte[] key) {
        SM4 sm4 = SmUtil.sm4((byte[])key);
        return sm4.decrypt(bytes);
    }

    public static class UcgKeyPair {
        private final byte[] privateKey;
        private final byte[] publicKey;

        public UcgKeyPair(byte[] privateKey, byte[] publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public byte[] getPrivateKey() {
            return this.privateKey;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }
    }
}

