/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.repeatrequest;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgRepeatRequestDepository;
import cn.com.yusys.udp.cloud.gateway.repeatrequest.UcgRepeatRequestNonceChecker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class UcgRepeatRequestRedisNonceChecker
extends UcgRepeatRequestNonceChecker {
    private static final String REDIS_KEY_PREFIX = "ucg:repeat-request:nonce:";
    private final RedisTemplate<String, String> redisTemplate;

    public UcgRepeatRequestRedisNonceChecker(UcgRepeatRequestDepository depository, RedisTemplate<String, String> redisTemplate) {
        super(depository);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean check(String nonce) {
        long incr = this.redisIncr(REDIS_KEY_PREFIX + nonce, this.depository.getCacheTimeMs());
        return incr <= 0L;
    }

    public long redisIncr(String key, long timeout) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, Objects.requireNonNull(this.redisTemplate.getConnectionFactory()));
        long increment = entityIdCounter.getAndIncrement();
        if (increment == 0L && timeout > 0L) {
            entityIdCounter.expire(timeout, TimeUnit.MILLISECONDS);
        }
        return increment;
    }
}

