/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.openapi;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthChecker;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;

public class UcgOpenApiSimpleAuthChecker
implements UcgOpenApiAuthChecker {
    @Override
    public Map<String, String> check(UcgOpenApiConfig.Client client, UcgOpenApiConfig.Path path, String clientSecret, String token, ServerWebExchange exchange) {
        if (path == null) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] \uff08" + client.getClientId() + "\uff09 API not found");
        }
        if (!client.getClientSecret().equals(clientSecret)) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] \uff08" + client.getClientId() + "\uff09 secret not match");
        }
        if (!client.getPathIds().contains(path.getId())) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " unauthorized request api +" + path.getId());
        }
        return null;
    }

    @Override
    public boolean match(UcgOpenApiConfig.Client client) {
        return client != null && "simple".equalsIgnoreCase(client.getAuthType());
    }
}

