/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.loadbalancer;

import cn.com.yusys.udp.cloud.commons.util.UcWebFluxIpUtils;
import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import cn.com.yusys.udp.cloud.lb.rule.IRule;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class UcgLocalFirstRule
extends IRule {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public UcgLocalFirstRule(String serviceId) {
        super(serviceId);
    }

    public Response<ServiceInstance> getInstanceResponse(Request request, List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No servers available for service: " + this.serviceId);
            }
            return new EmptyResponse();
        }
        ServerWebExchange exchange = UcgContext.getExchange();
        if (exchange != null) {
            String targetHost = UcWebFluxIpUtils.getIp((ServerHttpRequest)exchange.getRequest(), (boolean)true);
            for (ServiceInstance instance : instances) {
                if (!instance.getHost().equalsIgnoreCase(targetHost)) continue;
                return new DefaultResponse(instance);
            }
        }
        int index = ThreadLocalRandom.current().nextInt(instances.size());
        ServiceInstance instance = instances.get(index);
        return new DefaultResponse(instance);
    }
}

