/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.config.UcgUaaAuthConfig;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.uaa.UcgUaaAuthChecker;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgUaaAuthFilter
implements UcgFilter {
    public static final int ORDER = -2147483468;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UcgUaaAuthConfig config;
    protected final UcgUaaAuthChecker ucgUaaAuthChecker;

    public UcgUaaAuthFilter(UcgUaaAuthConfig config, UcgUaaAuthChecker ucgUaaAuthChecker) {
        this.config = config;
        this.ucgUaaAuthChecker = ucgUaaAuthChecker;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.config.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgUaaAuthFilter start");
        ServerHttpRequest request = exchange.getRequest();
        String requestPath = request.getPath().toString();
        AntPathMatcher apiMatcher = new AntPathMatcher();
        for (String path : this.config.getIgnorePaths()) {
            if (!apiMatcher.match(path, requestPath)) continue;
            this.logger.trace("[udp-cloud-gateway]: [UaaAuth] ignored path: {}", (Object)requestPath);
            return chain.filter(exchange);
        }
        if (this.ucgUaaAuthChecker == null) {
            throw new UcgException(HttpStatus.INTERNAL_SERVER_ERROR, "[udp-cloud-gateway]: [UaaAuth] UcgUaaAuthChecker not found");
        }
        Map<String, String> newHeaders = this.ucgUaaAuthChecker.checkToken(request, this.config);
        if (newHeaders != null && newHeaders.size() > 0) {
            ServerHttpRequest newRequest = exchange.getRequest().mutate().headers(httpHeaders -> {
                for (String key : newHeaders.keySet()) {
                    httpHeaders.put(key, Collections.singletonList(newHeaders.get(key)));
                }
            }).build();
            return chain.filter(exchange.mutate().request(newRequest).build());
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147483468;
    }
}

