/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgDegradeInDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgSentinelDegradeInFilter
implements UcgFilter {
    public static final int ORDER = -2147483248;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String module = "DEGRADE";
    protected final UcgDegradeInDepository depository;

    public UcgSentinelDegradeInFilter(UcgDegradeInDepository depository) {
        this.depository = depository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String[] resources;
        Mono mono = chain.filter(exchange);
        if (!this.depository.isEnabled()) {
            return mono;
        }
        this.logger.trace("[udp-cloud-gateway]: UcgSentinelDegradeInFilter start");
        for (String resource : resources = UcgUtils.getResources(exchange, module)) {
            if (!DegradeRuleManager.hasConfig((String)resource)) continue;
            this.logger.trace("[udp-cloud-gateway]: [DegradeIn] {}", (Object)resource);
            mono = mono.transform((Function)new SentinelReactorTransformer(new EntryConfig(resource, EntryType.IN, new ContextConfig(this.contextName(resource), ""))));
        }
        return mono;
    }

    private String contextName(String route) {
        return "sentinel_degrade_context$$route$$" + route;
    }

    public int getOrder() {
        return -2147483248;
    }
}

