/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgRewriteRequestBodyDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.handler.UcgRewriteRequestBodyHandler;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgRewriteRequestBodyFilter
implements UcgFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ORDER = -2147463648;
    private final UcgRewriteRequestBodyDepository depository;
    private final UcgRewriteRequestBodyHandler bodyHandler;

    public UcgRewriteRequestBodyFilter(UcgRewriteRequestBodyDepository depository, UcgRewriteRequestBodyHandler bodyHandler) {
        this.depository = depository;
        this.bodyHandler = bodyHandler;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgRewriteRequestBodyFilter start");
        String requestPath = exchange.getRequest().getPath().toString();
        if (!UcgUtils.antMatch(requestPath, this.depository.getPaths())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[udp-cloud-gateway]: [RewriteRequestBody] ignored path: {}", (Object)requestPath);
            }
            return chain.filter(exchange);
        }
        if (this.bodyHandler == null) {
            this.logger.warn("[udp-cloud-gateway]: [RewriteRequestBody] ignored: handler not found");
            return chain.filter(exchange);
        }
        return UcgUtils.rewriteRequestBody(exchange, chain, (serverWebExchange, raw) -> {
            if (raw == null) {
                return Mono.empty();
            }
            try {
                return Mono.just((Object)this.bodyHandler.handle(exchange, (String)raw));
            }
            catch (Exception e) {
                this.logger.error("request body rewrite error", (Throwable)e);
                throw new UcgException(HttpStatus.FORBIDDEN, "request body rewrite error");
            }
        }, null);
    }

    public int getOrder() {
        return -2147463648;
    }
}

