/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.commons.util.UcCryptoUtils;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRepeatRequestDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.repeatrequest.UcgRepeatRequestNonceChecker;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgRepeatRequestFilter
implements UcgFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ORDER = -2147483638;
    private final UcgRepeatRequestDepository depository;
    private final UcgRepeatRequestNonceChecker nonceChecker;

    public UcgRepeatRequestFilter(UcgRepeatRequestDepository depository, UcgRepeatRequestNonceChecker nonceChecker) {
        this.depository = depository;
        this.nonceChecker = nonceChecker;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        long rt;
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgRepeatRequestFilter start");
        String requestPath = exchange.getRequest().getPath().toString();
        if (!UcgUtils.antMatch(requestPath, this.depository.getPaths())) {
            this.logger.trace("[udp-cloud-gateway]: [RepeatRequest] ignored path: {}", (Object)requestPath);
            return chain.filter(exchange);
        }
        HttpMethod method = exchange.getRequest().getMethod();
        boolean needCheck = false;
        for (HttpMethod target : this.depository.getMethods()) {
            if (target != method) continue;
            needCheck = true;
            break;
        }
        if (!needCheck) {
            this.logger.trace("[udp-cloud-gateway]: [RepeatRequest] ignored method: {}", (Object)method);
            return chain.filter(exchange);
        }
        String timestamp = exchange.getRequest().getHeaders().getFirst(this.depository.getTimestampName());
        String nonce = exchange.getRequest().getHeaders().getFirst(this.depository.getNonceName());
        String sign = exchange.getRequest().getHeaders().getFirst(this.depository.getSignName());
        if (StringUtils.isEmpty((Object)timestamp) || StringUtils.isEmpty((Object)nonce) || StringUtils.isEmpty((Object)sign)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "nonce sign param check fail");
        }
        try {
            rt = Long.parseLong(timestamp);
        }
        catch (Exception e) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "repeat request param check fail: " + this.depository.getSignName());
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (Math.abs(currentTimeMillis - rt) > this.depository.getCacheTimeMs()) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "repeat request check fail: expired request - " + this.depository.getCacheTimeMs());
        }
        byte[] signBytes = UcCryptoUtils.md5((String)(this.depository.getSignKey() + timestamp + nonce));
        String targetSign = UcCryptoUtils.toHexString((byte[])signBytes);
        if (targetSign == null || !targetSign.equalsIgnoreCase(sign)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "repeat request check fail: sign check fail");
        }
        if (!this.nonceChecker.check(nonce)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "repeat request check fail: repeated request");
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147483638;
    }
}

