/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgInstanceDownDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgInstanceDownFilter
implements UcgFilter {
    public static final int ORDER = Integer.MIN_VALUE;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UcgInstanceDownDepository depository;

    public UcgInstanceDownFilter(UcgInstanceDownDepository depository) {
        this.depository = depository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgInstanceDownFilter start");
        if (this.depository.isDown()) {
            throw new UcgException(HttpStatus.SERVICE_UNAVAILABLE, "instance " + this.depository.getInstanceId() + " is down");
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

