/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgBodyDecryptDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcess;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcessSwitch;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgBodyEncryptResponseFilter
implements UcgFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ORDER = -1001;
    private final UcgBodyDecryptDepository depository;
    private UcgBodyProcess ucgBodyProcess;
    private UcgBodyProcessSwitch ucgBodyProcessSwitch;

    public UcgBodyEncryptResponseFilter(UcgBodyDecryptDepository depository, UcgBodyProcess ucgBodyProcess, UcgBodyProcessSwitch ucgBodyProcessSwitch) {
        this.ucgBodyProcess = ucgBodyProcess;
        this.depository = depository;
        this.ucgBodyProcessSwitch = ucgBodyProcessSwitch;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgBodyEncryptResponseFilter start");
        String requestPath = exchange.getRequest().getPath().toString();
        if (!this.ucgBodyProcessSwitch.responseProcessSwitch(exchange, this.depository)) {
            this.logger.trace("[udp-cloud-gateway]: [BodyDecryptResponse] skip ,path: {}", (Object)requestPath);
            return chain.filter(exchange);
        }
        return UcgUtils.rewriteResponseBody(exchange, chain, (serverWebExchange, raw) -> {
            if (raw == null) {
                return Mono.empty();
            }
            return Mono.just((Object)this.ucgBodyProcess.responseProcess((String)raw, this.depository, exchange));
        });
    }

    public int getOrder() {
        return -1001;
    }
}

