/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgBeforeFilter
implements GatewayFilter,
GlobalFilter,
Ordered {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<UcgFilter> ucgFilters;
    protected final List<UcgDepository<?>> ucgDepositories;

    public UcgBeforeFilter(List<UcgFilter> ucgFilters, List<UcgDepository<?>> ucgDepositories) {
        this.ucgFilters = ucgFilters;
        this.ucgDepositories = ucgDepositories;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Long startTime = System.currentTimeMillis();
        exchange.getAttributes().put(UcgUtils.REQUEST_START_TIME_ATTR, startTime);
        ServerHttpRequest request = exchange.getRequest();
        exchange.getAttributes().put(UcgUtils.REQUEST_ORIGIN_PATH_ATTR, request.getPath());
        exchange.getAttributes().put(UcgUtils.REQUEST_ORIGIN_METHOD_ATTR, request.getMethod());
        UcgContext.clear();
        UcgContext.setExchange(exchange);
        if (this.ucgFilters != null) {
            for (UcgFilter ucgFilter : this.ucgFilters) {
                try {
                    ucgFilter.preFilter(exchange);
                }
                catch (Exception e) {
                    this.logger.error("preFilter", (Throwable)e);
                }
            }
        }
        return chain.filter(exchange).doOnSuccess(m -> {
            if (this.ucgFilters != null) {
                for (UcgFilter ucgFilter : this.ucgFilters) {
                    try {
                        ucgFilter.successFilter(exchange);
                    }
                    catch (Exception e) {
                        this.logger.error("successFilter", (Throwable)e);
                    }
                }
            }
            UcgContext.clear();
        });
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

