/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.config.UcgSwaggerConfig;
import cn.com.yusys.udp.cloud.gateway.controller.UcgSwaggerExtController;
import cn.com.yusys.udp.cloud.gateway.filter.UcgSwaggerFilter;
import cn.com.yusys.udp.cloud.gateway.swagger.UcgSwaggerUiConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.annotation.Bean;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;
import springfox.documentation.swagger.web.UiConfiguration;

@ConditionalOnProperty(value={"springfox.documentation.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={UcgSwaggerConfig.class})
public class UcgSwaggerAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgSwaggerFilter UcgSwaggerFilter(RouteDefinitionLocator locator, SwaggerResourcesProvider resourcesProvider) {
        return new UcgSwaggerFilter(locator, resourcesProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    UiConfiguration uiConfiguration(UcgSwaggerConfig config) {
        UcgSwaggerUiConfigurationBuilder builder = UcgSwaggerUiConfigurationBuilder.builder();
        builder.validatorUrl(config.getValidatorUrl());
        builder.supportedSubmitMethods(config.getSupportedSubmitMethods());
        builder.showExtensions(config.isShowExtensions());
        builder.v2Authorization(config.getV2Authorization());
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(name={"udp.cloud.gateway.swagger-api.enabled"}, matchIfMissing=true)
    public UcgSwaggerExtController ucgSwaggerExtController() {
        this.logger.info("[udp-cloud-gateway]: register UcgSwaggerExtController");
        return new UcgSwaggerExtController();
    }
}

