/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.UcgAutoConfiguration;
import cn.com.yusys.udp.cloud.gateway.config.UcgRepeatRequestConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRepeatRequestDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgRepeatRequestFilter;
import cn.com.yusys.udp.cloud.gateway.repeatrequest.UcgRepeatRequestMemNonceChecker;
import cn.com.yusys.udp.cloud.gateway.repeatrequest.UcgRepeatRequestNonceChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={UcgAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.repeat-request.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcgRepeatRequestConfig.class})
public class UcgRepeatRequestAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgRepeatRequestDepository ucgRepeatRequestDepository(UcgRepeatRequestConfig properties) {
        return new UcgRepeatRequestDepository(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcgRepeatRequestNonceChecker ucgRepeatRequestNonceChecker(UcgRepeatRequestDepository depository) {
        this.logger.info("[udp-cloud-gateway]: register UcgRepeatRequestMemNonceChecker");
        return new UcgRepeatRequestMemNonceChecker(depository);
    }

    @Bean
    public UcgRepeatRequestFilter ucgRepeatRequestFilter(UcgRepeatRequestDepository ucgRepeatRequestDepository, UcgRepeatRequestNonceChecker ucgRepeatRequestNonceChecker) {
        this.logger.info("[udp-cloud-gateway]: register UcgRepeatRequestFilter");
        return new UcgRepeatRequestFilter(ucgRepeatRequestDepository, ucgRepeatRequestNonceChecker);
    }
}

