/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.controller.UcgJwtTokenController;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgOpenApiDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgOpenApiFilter;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthChecker;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthCheckerFactory;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiHttpAuthChecker;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiIgnoreAuthChecker;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiJwtAuthChecker;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiSimpleAuthChecker;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

public class UcgOpenApiAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgOpenApiDepository ucgOpenApiDepository(UcgOpenApiConfig properties) {
        return new UcgOpenApiDepository(properties);
    }

    @Bean
    public UcgOpenApiFilter openApiFilter(UcgOpenApiDepository UcgOpenApiDepository2, UcgOpenApiAuthCheckerFactory ucgOpenApiAuthCheckerFactory) {
        this.logger.info("[udp-cloud-gateway]: register UcgOpenApiFilter");
        return new UcgOpenApiFilter(UcgOpenApiDepository2, ucgOpenApiAuthCheckerFactory);
    }

    @Bean
    public UcgOpenApiAuthCheckerFactory ucgOpenApiAuthCheckerFactory(List<UcgOpenApiAuthChecker> checkers) {
        for (UcgOpenApiAuthChecker checker : checkers) {
            this.logger.info("[udp-cloud-gateway]: register UcgOpenApiAuthChecker-{}", (Object)checker.getClass().getSimpleName());
        }
        return new UcgOpenApiAuthCheckerFactory(checkers);
    }

    @Bean
    @Order(value=1)
    public UcgOpenApiIgnoreAuthChecker ucgOpenApiIgnoreAuthChecker() {
        return new UcgOpenApiIgnoreAuthChecker();
    }

    @Bean
    @Order(value=2)
    public UcgOpenApiAuthChecker ucgOpenApiSimpleAuthChecker() {
        return new UcgOpenApiSimpleAuthChecker();
    }

    @Bean
    @Order(value=3)
    public UcgOpenApiAuthChecker ucgOpenApiJwtAuthChecker() {
        return new UcgOpenApiJwtAuthChecker();
    }

    @Bean
    @Order(value=4)
    public UcgOpenApiAuthChecker ucgOpenApiHttpAuthChecker(UcgOpenApiDepository depository, @Autowired(required=false) LoadBalancerClient loadBalancer) {
        return new UcgOpenApiHttpAuthChecker(depository, loadBalancer);
    }

    @Bean
    @ConditionalOnProperty(name={"udp.cloud.gateway.open-api-jwt-api.enabled"}, matchIfMissing=true)
    public UcgJwtTokenController ucgJwtTokenController() {
        this.logger.info("[udp-cloud-gateway]: register UcgJwtTokenController");
        return new UcgJwtTokenController();
    }
}

