/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.UcgAutoConfiguration;
import cn.com.yusys.udp.cloud.gateway.config.UcgIpLimitConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgIpLimitDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgIpLimitFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={UcgAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.ip-limit.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcgIpLimitConfig.class})
public class UcgIpLimitAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgIpLimitDepository ucgIPLimitDepository(UcgIpLimitConfig properties) {
        return new UcgIpLimitDepository(properties);
    }

    @Bean
    public UcgIpLimitFilter ucgIPLimitFilter(UcgIpLimitDepository ucgIPLimitDepository) {
        this.logger.info("[udp-cloud-gateway]: register UcgIPLimitFilter");
        return new UcgIpLimitFilter(ucgIPLimitDepository);
    }
}

