/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.UcgAutoConfiguration;
import cn.com.yusys.udp.cloud.gateway.config.UcgInstanceDownConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgInstanceDownDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgInstanceDownFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@AutoConfigureAfter(value={UcgAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.instance-down.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcgInstanceDownConfig.class})
public class UcgInstanceDownAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UcgInstanceDownDepository depository;

    @Bean
    public UcgInstanceDownDepository ucgInstanceDownDepository(UcgInstanceDownConfig properties, Environment env) {
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)env, (boolean)false);
        this.logger.info("[udp-cloud-gateway]: register instance id: {}", (Object)instanceId);
        this.depository = new UcgInstanceDownDepository(properties, instanceId);
        return this.depository;
    }

    @Bean
    public UcgInstanceDownFilter ucgInstanceDownFilter(UcgInstanceDownDepository ucgInstanceDownDepository) {
        this.logger.info("[udp-cloud-gateway]: register UcgInstanceDownFilter");
        return new UcgInstanceDownFilter(ucgInstanceDownDepository);
    }

    @EventListener(value={InstancePreRegisteredEvent.class})
    public void eventListener(InstancePreRegisteredEvent event) {
        Registration registration = event.getRegistration();
        String instanceId = registration.getHost() + ":" + registration.getPort();
        if (this.depository != null) {
            this.logger.info("[udp-cloud-gateway]: register instance id: {}", (Object)instanceId);
            this.depository.setInstanceId(instanceId);
        }
    }
}

