/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.UcgAutoConfiguration;
import cn.com.yusys.udp.cloud.gateway.config.UcgBodyDecryptConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgBodyDecryptDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgBodyDecryptFilter;
import cn.com.yusys.udp.cloud.gateway.filter.UcgBodyEncryptResponseFilter;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyOtherProcess;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyOtherProcessImplDefault;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcess;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcessImplDefault;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcessSwitch;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcessSwitchImplDefault;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={UcgAutoConfiguration.class})
@ConditionalOnClass(value={SentinelReactorTransformer.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.body-decrypt.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcgBodyDecryptConfig.class})
public class UcgBodyDecryptAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgBodyDecryptDepository ucgBodyDecryptDepository(UcgBodyDecryptConfig config) {
        return new UcgBodyDecryptDepository(config);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcgBodyDecryptFilter ucgBodyDecryptFilter(UcgBodyDecryptDepository depository, UcgBodyProcess ucgBodyProcess, UcgBodyProcessSwitch ucgBodyProcessSwitch) {
        this.logger.info("[udp-cloud-gateway]: register UcgBodyDecryptFilter");
        return new UcgBodyDecryptFilter(depository, ucgBodyProcess, ucgBodyProcessSwitch);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcgBodyEncryptResponseFilter ucgBodyEncryptResponseFilter(UcgBodyDecryptDepository depository, UcgBodyProcess ucgBodyProcess, UcgBodyProcessSwitch ucgBodyProcessSwitch) {
        this.logger.info("[udp-cloud-gateway]: register UcgBodyEncryptResponseFilter");
        return new UcgBodyEncryptResponseFilter(depository, ucgBodyProcess, ucgBodyProcessSwitch);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcgBodyOtherProcess ucgBodyOtherProcess() {
        return new UcgBodyOtherProcessImplDefault();
    }

    @Bean
    @ConditionalOnMissingBean
    public UcgBodyProcess ucgBodyProcess(UcgBodyOtherProcess ucgBodyOtherProcess) {
        return new UcgBodyProcessImplDefault(ucgBodyOtherProcess);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcgBodyProcessSwitch ucgBodyProcessSwitch() {
        return new UcgBodyProcessSwitchImplDefault();
    }
}

