/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.actuate;

import cn.com.yusys.udp.cloud.gateway.config.UcgConfig;
import cn.com.yusys.udp.cloud.gateway.config.UcgMetricsConfig;
import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.config.UcgRequestLogConfig;
import cn.com.yusys.udp.cloud.gateway.config.UcgRewriteRequestBodyConfig;
import cn.com.yusys.udp.cloud.gateway.config.UcgRewriteResponseBodyConfig;
import cn.com.yusys.udp.cloud.gateway.config.UcgUaaAuthConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgBodyDecryptDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDegradeInDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgFlowInDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgInstanceDownDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgIpLimitDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgOpenApiDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRepeatRequestDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRetryDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRewriteRequestBodyDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRewriteResponseBodyDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthChecker;
import cn.com.yusys.udp.cloud.gateway.uaa.UcgUaaAuthChecker;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import reactor.core.publisher.Mono;

@RestControllerEndpoint(id="ucg")
public class UcgControllerEndpoint {
    @Autowired
    private ApplicationContext applicationContext;

    @GetMapping(value={"/"})
    public Mono<Map<String, Object>> enabled() {
        UcgInstanceDownDepository instanceDownDepository = this.getBean(UcgInstanceDownDepository.class);
        UcgIpLimitDepository ipLimitDepository = this.getBean(UcgIpLimitDepository.class);
        UcgOpenApiDepository openApiDepository = this.getBean(UcgOpenApiDepository.class);
        UcgFlowInDepository flowInDepository = this.getBean(UcgFlowInDepository.class);
        UcgDegradeInDepository degradeInDepository = this.getBean(UcgDegradeInDepository.class);
        UcgRetryDepository retryDepository = this.getBean(UcgRetryDepository.class);
        UcgRepeatRequestDepository repeatRequestDepository = this.getBean(UcgRepeatRequestDepository.class);
        UcgBodyDecryptDepository bodyDecryptDepository = this.getBean(UcgBodyDecryptDepository.class);
        UcgUaaAuthConfig ucgUaaAuthConfig = this.getBean(UcgUaaAuthConfig.class);
        UcgRequestLogConfig ucgRequestLogConfig = this.getBean(UcgRequestLogConfig.class);
        UcgMetricsConfig ucgMetricsConfig = this.getBean(UcgMetricsConfig.class);
        UcgRewriteRequestBodyConfig ucgRewriteRequestBodyConfig = this.getBean(UcgRewriteRequestBodyConfig.class);
        UcgRewriteResponseBodyConfig ucgRewriteResponseBodyConfig = this.getBean(UcgRewriteResponseBodyConfig.class);
        LinkedHashMap<String, Object> rt = new LinkedHashMap<String, Object>();
        this.addEnabled(rt, "instanceDown", instanceDownDepository);
        this.addEnabled(rt, "ipLimit", ipLimitDepository);
        this.addEnabled(rt, "openApi", openApiDepository);
        this.addEnabled(rt, "flowIn", flowInDepository);
        this.addEnabled(rt, "degradeIn", degradeInDepository);
        this.addEnabled(rt, "retry", retryDepository);
        this.addEnabled(rt, "repeatRequest", repeatRequestDepository);
        this.addEnabled(rt, "bodyDecrypt", bodyDecryptDepository);
        this.addEnabled(rt, "uaaAuth", ucgUaaAuthConfig);
        this.addEnabled(rt, "requestLog", ucgRequestLogConfig);
        this.addEnabled(rt, "metrics", ucgMetricsConfig);
        this.addEnabled(rt, "rewriteRequestBody", ucgRewriteRequestBodyConfig);
        this.addEnabled(rt, "rewriteResponseBody", ucgRewriteResponseBodyConfig);
        return Mono.just(rt);
    }

    public void addEnabled(Map<String, Object> rt, String key, UcgDepository<?> depository) {
        if (depository != null && depository.isEnabled()) {
            rt.put(key, true);
        } else {
            rt.put(key, false);
        }
    }

    public void addEnabled(Map<String, Object> rt, String key, UcgConfig config) {
        if (config != null && config.isEnabled()) {
            rt.put(key, true);
        } else {
            rt.put(key, false);
        }
    }

    @GetMapping(value={"/instanceDown"})
    public Mono<Map<String, Object>> instanceDown() {
        LinkedHashMap<String, Object> rt;
        UcgInstanceDownDepository instanceDownDepository = this.getBean(UcgInstanceDownDepository.class);
        if (this.addCommon(instanceDownDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("instanceId", instanceDownDepository.getInstanceId());
        rt.put("isDown", instanceDownDepository.isDown());
        rt.put("ids", instanceDownDepository.getIds());
        return Mono.just(rt);
    }

    @GetMapping(value={"/ipLimit"})
    public Mono<Map<String, Object>> ipLimit() {
        LinkedHashMap<String, Object> rt;
        UcgIpLimitDepository ipLimitDepository = this.getBean(UcgIpLimitDepository.class);
        if (this.addCommon(ipLimitDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("blackIps", ipLimitDepository.getBlackIpAreas());
        rt.put("whiteIps", ipLimitDepository.getWhiteIpAreas());
        return Mono.just(rt);
    }

    @GetMapping(value={"/openApi"})
    public Mono<Map<String, Object>> openApi() {
        LinkedHashMap<String, Object> rt;
        UcgOpenApiDepository openApiDepository = this.getBean(UcgOpenApiDepository.class);
        if (this.addCommon(openApiDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        List checkers = this.applicationContext.getBeanProvider(UcgOpenApiAuthChecker.class).stream().collect(Collectors.toList());
        ArrayList<String> checkerNames = new ArrayList<String>();
        for (UcgOpenApiAuthChecker checker : checkers) {
            checkerNames.add(checker.getClass().getName());
        }
        rt.put("openApiAuthCheckers", checkerNames);
        rt.put("ignorePaths", openApiDepository.getIgnorePaths());
        rt.put("clientIdName", openApiDepository.getClientIdName());
        rt.put("clientSecretName", openApiDepository.getClientSecretName());
        rt.put("keepClientSecret", openApiDepository.isKeepClientSecret());
        rt.put("httpAuthUrl", openApiDepository.getHttpAuthUrl());
        rt.put("defaultClientId", openApiDepository.getDefaultClientId());
        rt.put("defaultClientSecret", openApiDepository.getDefaultClientSecret() == null ? null : "***");
        rt.put("paths", openApiDepository.getPaths());
        rt.put("antPaths", openApiDepository.getAntPaths());
        HashMap<String, UcgOpenApiConfig.Client> users = new HashMap<String, UcgOpenApiConfig.Client>(16);
        Map<String, UcgOpenApiConfig.Client> cachedUserMap = openApiDepository.getClients();
        for (String userName : cachedUserMap.keySet()) {
            UcgOpenApiConfig.Client cachedClient = cachedUserMap.get(userName);
            UcgOpenApiConfig.Client client = new UcgOpenApiConfig.Client();
            client.setPathIds(cachedClient.getPathIds());
            client.setAuthType(cachedClient.getAuthType());
            client.setClientId(cachedClient.getClientId());
            client.setClientSecret("***");
            users.put(userName, client);
        }
        rt.put("users", users);
        return Mono.just(rt);
    }

    @GetMapping(value={"/flowIn"})
    public Mono<Map<String, Object>> flowIn() {
        LinkedHashMap<String, Object> rt;
        UcgFlowInDepository flowInDepository = this.getBean(UcgFlowInDepository.class);
        if (this.addCommon(flowInDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("rules", flowInDepository.getRules());
        rt.put("gatewayFlowRules", GatewayRuleManager.getRules());
        rt.put("apiGroups", flowInDepository.getApiGroups());
        rt.put("apiDefinitions", GatewayApiDefinitionManager.getApiDefinitions());
        return Mono.just(rt);
    }

    @GetMapping(value={"/degradeIn"})
    public Mono<Map<String, Object>> degradeIn() {
        LinkedHashMap<String, Object> rt;
        UcgDegradeInDepository degradeInDepository = this.getBean(UcgDegradeInDepository.class);
        if (this.addCommon(degradeInDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("rules", degradeInDepository.getRules());
        rt.put("degradeRules", DegradeRuleManager.getRules());
        return Mono.just(rt);
    }

    @GetMapping(value={"/retry"})
    public Mono<Map<String, Object>> retry() {
        LinkedHashMap<String, Object> rt;
        UcgRetryDepository retryDepository = this.getBean(UcgRetryDepository.class);
        if (this.addCommon(retryDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("rules", retryDepository.getRules());
        return Mono.just(rt);
    }

    @GetMapping(value={"repeatRequest"})
    public Mono<Map<String, Object>> repeatRequest() {
        LinkedHashMap<String, Object> rt;
        UcgRepeatRequestDepository repeatRequestDepository = this.getBean(UcgRepeatRequestDepository.class);
        if (this.addCommon(repeatRequestDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("paths", repeatRequestDepository.getPaths());
        rt.put("methods", repeatRequestDepository.getMethods());
        rt.put("cacheTimeMs", repeatRequestDepository.getCacheTimeMs());
        return Mono.just(rt);
    }

    @GetMapping(value={"bodyDecrypt"})
    public Mono<Map<String, Object>> bodyDecrypt() {
        LinkedHashMap<String, Object> rt;
        UcgBodyDecryptDepository bodyDecryptDepository = this.getBean(UcgBodyDecryptDepository.class);
        if (this.addCommon(bodyDecryptDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        return Mono.just(rt);
    }

    @GetMapping(value={"/uaaAuth"})
    public Mono<Map<String, Object>> uaaAuth() {
        UcgUaaAuthConfig ucgUaaAuthConfig = this.getBean(UcgUaaAuthConfig.class);
        UcgUaaAuthChecker ucgUaaAuthChecker = this.getBean(UcgUaaAuthChecker.class);
        LinkedHashMap<String, Object> rt = new LinkedHashMap<String, Object>();
        if (this.addCommon(ucgUaaAuthConfig, rt)) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("uaaAuthChecker", ucgUaaAuthChecker == null ? null : ucgUaaAuthChecker.getClass().getName());
        rt.put("ignorePaths", ucgUaaAuthConfig.getIgnorePaths());
        return Mono.just(rt);
    }

    @GetMapping(value={"/requestLog"})
    public Mono<Map<String, Object>> requestLog() {
        LinkedHashMap<String, Object> rt;
        UcgRequestLogConfig ucgRequestLogConfig = this.getBean(UcgRequestLogConfig.class);
        if (this.addCommon(ucgRequestLogConfig, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        return Mono.just(rt);
    }

    @GetMapping(value={"/metrics"})
    public Mono<Map<String, Object>> metrics() {
        LinkedHashMap<String, Object> rt;
        UcgMetricsConfig ucgMetricsConfig = this.getBean(UcgMetricsConfig.class);
        if (this.addCommon(ucgMetricsConfig, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        return Mono.just(rt);
    }

    @GetMapping(value={"rewriteRequestBody"})
    public Mono<Map<String, Object>> rewriteRequestBody() {
        LinkedHashMap<String, Object> rt;
        UcgRewriteRequestBodyDepository rewriteRequestBodyDepository = this.getBean(UcgRewriteRequestBodyDepository.class);
        if (this.addCommon(rewriteRequestBodyDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("paths", rewriteRequestBodyDepository.getPaths());
        return Mono.just(rt);
    }

    @GetMapping(value={"rewriteResponseBody"})
    public Mono<Map<String, Object>> rewriteResponseBody() {
        LinkedHashMap<String, Object> rt;
        UcgRewriteResponseBodyDepository rewriteResponseBodyDepository = this.getBean(UcgRewriteResponseBodyDepository.class);
        if (this.addCommon(rewriteResponseBodyDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("paths", rewriteResponseBodyDepository.getPaths());
        return Mono.just(rt);
    }

    private boolean addCommon(UcgDepository<?> depository, Map<String, Object> rt) {
        if (depository == null) {
            return true;
        }
        rt.put("enabled", depository.isEnabled());
        return false;
    }

    private boolean addCommon(UcgConfig config, Map<String, Object> rt) {
        if (config == null) {
            return true;
        }
        rt.put("enabled", config.isEnabled());
        return false;
    }

    private String formatTime(Long time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(new Date(time));
    }

    private <T> T getBean(Class<T> clazz) {
        try {
            return (T)this.applicationContext.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }
}

