/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class UcgEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String ENDPOINT_GATEWAY_ENABLED = "management.endpoint.gateway.enabled";
    private static final String PROPERTY_SOURCE_NAME = "ucgDefaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertySource source;
        System.setProperty("csp.sentinel.app.type", "11");
        System.setProperty("jasypt.encryptor.bean", "yuspStringEncryptor");
        MutablePropertySources propertySources = environment.getPropertySources();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        if (!environment.containsProperty(ENDPOINT_GATEWAY_ENABLED)) {
            map.put(ENDPOINT_GATEWAY_ENABLED, false);
        }
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }
}

