/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway;

import cn.com.yusys.udp.cloud.gateway.UcgErrorWebExceptionHandler;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgBeforeFilter;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration(proxyBeanMethods=false)
public class UcgAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private List<UcgDepository<?>> ucgDepositories;

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean
    public UcgErrorWebExceptionHandler ucgErrorWebExceptionHandler(List<UcgFilter> ucgFilters, ObjectProvider<List<ViewResolver>> viewResolversProvider, ServerCodecConfigurer serverCodecConfigurer) {
        this.logger.info("[udp-cloud-gateway]: register UcgErrorWebExceptionHandler");
        return new UcgErrorWebExceptionHandler(ucgFilters, serverCodecConfigurer.getReaders(), serverCodecConfigurer.getWriters(), (List)viewResolversProvider.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean
    public UcgBeforeFilter ucgBeforeFilter(List<UcgFilter> ucgFilters, List<UcgDepository<?>> ucgDepositories) {
        this.logger.info("[udp-cloud-gateway]: register UcgBeforeFilter");
        return new UcgBeforeFilter(ucgFilters, ucgDepositories);
    }

    @EventListener(classes={RefreshScopeRefreshedEvent.class})
    public void handleRefreshScopeRefreshedEvent(RefreshScopeRefreshedEvent event) {
        if (this.ucgDepositories == null) {
            return;
        }
        this.logger.info("[udp-cloud-gateway]: refreshScopeRefreshed {}", (Object)event.getName());
        for (UcgDepository<?> depository : this.ucgDepositories) {
            depository.onRefresh();
        }
    }
}

