/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.util;

import cn.com.yusys.udp.cloud.commons.bean.UserInfo;
import cn.com.yusys.udp.cloud.commons.util.UcUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.RequestPath;
import org.springframework.web.server.ServerWebExchange;

public final class UcgUtils
extends UcUtils {
    public static final String REQUEST_ORIGIN_PATH_ATTR = UcgUtils.qualify("requestOriginPath");
    public static final String REQUEST_ORIGIN_METHOD_ATTR = UcgUtils.qualify("requestOriginMethod");
    public static final String REQUEST_START_TIME_ATTR = UcgUtils.qualify("requestStartTime");
    public static final String REQUEST_OPEN_API_ID_ATTR = UcgUtils.qualify("requestOpenApiId");
    public static final String REQUEST_OPEN_API_ADD_HEADERS_ATTR = UcgUtils.qualify("requestOpenApiAddHeaders");
    public static final String DEFAULT_LOAD_BALANCER_ATTR = UcgUtils.qualify("defaultLoadBalancer");
    public static final String RETRY_RULE = UcgUtils.qualify("retryRule");
    public static final String MODULE_FLOW = "FLOW";
    public static final String MODULE_DEGRADE = "DEGRADE";
    public static final String MODULE_LOADBALANCER = "LB";
    public static final String MODULE_RETRY = "RETRY";
    public static final int FLOW_EXT_RESOURCE_MODE = 2;
    public static final String DEFAULT_CLIENT_ID_NAME = "X-Udp-Client-Id";
    public static final String DEFAULT_CLIENT_SECRET_NAME = "X-Udp-Client-Secret";
    public static final String TOKEN_KEY_NAME = "Authorization";
    public static final long DEFAULT_JWT_TIMEOUT = 3600000L;
    public static final long DEFAULT_HTTP_AUTH_TIMEOUT = 1000L;
    public static final String DEFAULT_SESSION_CONTEXT_CLASS = "cn.com.yusys.yusp.commons.session.context.UserContext";
    public static final String OPEN_API_AUTH_TYPE_SIMPLE = "simple";
    public static final String OPEN_API_AUTH_TYPE_JWT = "jwt";
    public static final String OPEN_API_AUTH_TYPE_HTTP = "http";

    public static String[] getResources(ServerWebExchange exchange, String module) {
        Route route;
        ArrayList<String> list = new ArrayList<String>();
        String openApiId = (String)exchange.getAttribute(REQUEST_OPEN_API_ID_ATTR);
        if (openApiId != null) {
            list.add(module + ":" + "API:" + openApiId);
        }
        if ((route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR)) != null && route.getId() != null) {
            list.add(module + ":" + "ROUTE:" + route.getId());
        }
        list.add(module + ":" + "SYS_GLOBAL");
        return list.toArray(new String[0]);
    }

    public static String buildRequestLog(boolean success, ServerWebExchange exchange, String msg) {
        HttpMethod httpMethod = (HttpMethod)exchange.getAttribute(REQUEST_ORIGIN_METHOD_ATTR);
        if (httpMethod == null) {
            httpMethod = exchange.getRequest().getMethod();
        }
        String method = httpMethod == null ? "" : httpMethod.name();
        RequestPath requestPath = (RequestPath)exchange.getAttribute(REQUEST_ORIGIN_PATH_ATTR);
        if (requestPath == null) {
            requestPath = exchange.getRequest().getPath();
        }
        String path = requestPath.value();
        Long startTime = (Long)exchange.getAttribute(REQUEST_START_TIME_ATTR);
        HttpStatus statusCode = exchange.getResponse().getStatusCode();
        int code = statusCode == null ? 0 : statusCode.value();
        String rt = "Request " + (success ? "proxy" : "direct") + ": " + method + " " + path + " [" + code + "]";
        if (startTime != null) {
            rt = rt + "(" + (System.currentTimeMillis() - startTime) + "ms)";
        }
        if (msg != null && !"".equals(msg.trim())) {
            rt = rt + " -> " + msg;
        }
        return rt;
    }

    public static String buildBaggageSessionContext(UserInfo userInfo, String userKeyClass) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String userInfoJson = objectMapper.writeValueAsString((Object)userInfo);
            String userKey = new String(Base64.getEncoder().encode(userInfoJson.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            HashMap<String, String> contextMap = new HashMap<String, String>(4);
            contextMap.put("UserKey", userKey);
            contextMap.put("UserKey_class", userKeyClass);
            String contextMapJson = objectMapper.writeValueAsString(contextMap);
            return new String(Base64.getEncoder().encode(contextMapJson.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    protected static String qualify(String attr) {
        return UcgUtils.class.getName() + "." + attr;
    }
}

